#rem 4-light Receiver.BAS  The Receiver gets a 433 Mhz signal from a 4-light transmiitter
which sends the preamble code and the a number in ascii from "0" to "7","L',"V"
It energizes one or more outlets and a coax jack with 28V for the Las Vegas ddisplay
John Saunders 6/3/2020. New relays and driver
#endrem
#PICAXE 14M2

'Input Ports
symbol Rcvr_In       = C.1			'Receiver signal, Idle low
symbol Rcvr_Int     = pinC.0		    'Receiver interrupt goes +ve
symbol I_Port        = pinC.4		     'Connected to the CLR pushbutton

'Output Ports
symbol LampW          = B.3	'White (W)
symbol LampR           = B.2	'Red  (R)
symbol LampG           = B.1	'Green (G)
symbol LampB           = B.4	'Blue (B)
symbol White_LED    = B.5	'Shows a received signal intended or spurious
symbol LV_Port         = C.2	'Outputs 24V to the Las Vegas Sign
    
'Variables    
symbol ValInput   = bit0
symbol Rcvr_Val     = b1	'0=OFF,1=White,2=Red,3=Yellow,4=Green,5=Maroon,6=Blue,7=Violet
symbol Rec_Indx     = b2

Init:
SETFREQ m4
LOW LampW
LOW LampR
LOW lampG
LOW LampB
LOW LV_Port
DO
	PAUSE 200
LOOP UNTIL I_port = 1
LET ValInput = 0
SETINT %00000001,%00000001	'Interrupt when Rcvr_Int high

Main:
PAUSE 990
IF I_Port =0 THEN Init
IF ValInput = 1 THEN
	HIGH White_LED
	PAUSE 500
	LOW White_LED
ENDIF
LET ValInput = 0
GOTO Main

Interrupt:
SETFREQ m16
DO WHILE Rcvr_Int = 1		'Interrupt is triggered by a 20 ms burst which exceeds intergator threshold
LOOP
LET Rcvr_Val = "Z"
SERIN [70,End_Interrupt],Rcvr_In,N2400_16,("14L1776"),Rcvr_Val
IF Rcvr_Val =  "Z" THEN End_Interrupt
LET ValInput = 1
SELECT Rcvr_Val
	CASE "0"
		LOW LampW			'Owl Fountain off
	CASE "1"
		HIGH LampW			'Owl Fountain on
	CASE "2"
		LOW LampR			'Cherub Fountain off
	CASE "3"
		HIGH LampR			'Cherub Fountain on
	CASE "4"
		LOW LampG			'Strip Lights off
	CASE "5"
		HIGH LampG			'Strip Lights on	
	CASE "6"
		LOW LampB			'String  Lights off
	CASE "7"
		HIGH LampB			'String  Lights on
	CASE "L"
		HIGH LV_Port		'Las Vegas Sign on
	CASE "V"
		LOW LV_Port			'Las Vegas Sign off
	ELSE
		LET ValInput = 0
ENDSELECT
End_Interrupt:
SETINT %00000001,%00000001	'Interrupt when Rcvr_Int high
RETURN